* This do-file: Bootstraps true fraction for sensitive answer
* Author:		Andres Ham (EGOB-UNIANDES)
* This version: 07/26/2022

capture program drop bs_tf
program define bs_tf, rclass
version 16

syntax [if], [Controls(string)] 

if "`if'" == "" {
	loc if = ""
	}
	
else {
	loc if = "`if'"
	}
	
if "`controls'" == "" {
	loc controls = ""
	}

* PROCESS
quietly {

	* Matrices
	mat d=J(3,1,.)
	mat v=J(3,1,.)

	* Calculates direct response mean
	local lists "1 2 3"
	foreach i of local lists {
	
		summ d_`i' [w=factor] `if'
		mat d[`i',1]=r(mean)
	
	loc ++i
	}

	* Estimates regressions
	foreach i of local lists{
		reg l`i' grupo `controls' [w=factor] `if', r
		mat beta=e(b)
		mat v[`i',1]=beta[1,1]
		
		loc ++i
	}
	
	* Sums
	mat b = d + v

}

* Scalars
return scalar sum_l1 = b[1,1]
return scalar sum_l2 = b[2,1]
return scalar sum_l3 = b[3,1]

end

